%This program runs the simulations behind Fig. 7.

%It conducts 1000 experiments of 1.10^6 episodes, with 2 AMMs but AMM 2 always playing a_2 = 5.0, 
%Delta_v = 4 and \sigma = 5, and records the average outcome in each episode as well as
%all the variables in the last episode.

clear

% record running time
% when producing the data the running time was 360 seconds
tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.
a2 = 5;                 %a2     is the constant price played by AMM 2

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l=5;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
% Can be commented out to run without parallelization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

%Call the function simulation_rep to run K experiments
[last_episodes, av_all_episodes]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,a2,K);

%Save the output in the subfolder "Data"
writematrix(last_episodes,'Data/last_episodes.txt');
writematrix(av_all_episodes,'Data/av_all_episodes.txt');

toc